(function(){
  // Mobil menü
  const toggle = document.getElementById('navToggle');
  const mobileNav = document.getElementById('mobileNav');
  if(toggle && mobileNav){
    toggle.addEventListener('click', ()=> mobileNav.classList.toggle('open'));
    mobileNav.querySelectorAll('a').forEach(a=>a.addEventListener('click', ()=>mobileNav.classList.remove('open')));
  }

  // Smooth scroll + topbar offset
  document.querySelectorAll('a[href^="#"]').forEach(a=>{
    a.addEventListener('click', (e)=>{
      const id = a.getAttribute('href');
      const el = document.querySelector(id);
      if(!el) return;
      e.preventDefault();
      const topbar = document.querySelector('.topbar');
      const offset = topbar ? topbar.offsetHeight + 10 : 70;
      const y = el.getBoundingClientRect().top + window.pageYOffset - offset;
      window.scrollTo({ top: y, behavior: 'smooth' });
      history.pushState(null, '', id);
    });
  });

  // Hero slider background
  const bg = document.getElementById('heroBg');
  const slides = (window.__SLIDES__ || []).filter(Boolean);
  if(bg && slides.length){
    let i = 0;
    const set = (idx)=>{
      bg.style.backgroundImage =
        `linear-gradient(90deg, rgba(245,242,238,.92) 0%, rgba(245,242,238,.82) 45%, rgba(245,242,238,.25) 100%), url('${slides[idx]}')`;
    };
    set(0);

    setInterval(()=>{
      i = (i+1) % slides.length;
      bg.classList.remove('fade'); void bg.offsetWidth; bg.classList.add('fade');
      set(i);
    }, 4500);
  }
})();
