<?php
require_once __DIR__ . '/db.php';

$ayar = $db->query("SELECT * FROM site_ayarlar WHERE id=1")->fetch();
$slides = $db->query("SELECT * FROM slider_resimler WHERE aktif=1 ORDER BY sira ASC, id ASC")->fetchAll();

if (!$slides) {
  // ilk kurulumda boşsa, statik placeholder
  $slides = [
    ['dosya' => 'assets/images/slider/slide1.jpg'],
    ['dosya' => 'assets/images/slider/slide2.jpg'],
    ['dosya' => 'assets/images/slider/slide3.jpg'],
  ];
}

$ok = isset($_GET['ok']);
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Psikolog</title>

  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Playfair+Display:wght@500;600;700&display=swap" rel="stylesheet">

  <link rel="stylesheet" href="assets/css/style.css?v=1" />
</head>
<body>

<header class="topbar">
  <div class="container topbar__inner">
    <div class="brand">
      <div class="brand__mark">Ψ</div>
      <div class="brand__text">PSIKOLOG</div>
    </div>

    <nav class="nav">
      <a href="#anasayfa" class="nav__link">Anasayfa</a>
      <a href="#hakkimda" class="nav__link">Hakkımda</a>
      <a href="#hizmetler" class="nav__link">Hizmetler</a>
      <a href="#blog" class="nav__link">Blog</a>
      <a href="#iletisim" class="nav__link">İletişim</a>
    </nav>

    <a class="btn btn--primary btn--pill" href="#randevu"><?php echo htmlspecialchars($ayar['hero_buton1']); ?></a>

    <button class="navtoggle" id="navToggle" aria-label="Menü">
      <span></span><span></span><span></span>
    </button>
  </div>

  <div class="mobileNav" id="mobileNav">
    <a href="#anasayfa">Anasayfa</a>
    <a href="#hakkimda">Hakkımda</a>
    <a href="#hizmetler">Hizmetler</a>
    <a href="#blog">Blog</a>
    <a href="#iletisim">İletişim</a>
    <a class="btn btn--primary" href="#randevu"><?php echo htmlspecialchars($ayar['hero_buton1']); ?></a>
  </div>
</header>

<main>
  <!-- HERO + SLIDER -->
  <section id="anasayfa" class="hero">
    <div class="hero__bg" id="heroBg"></div>

    <div class="container hero__inner">
      <div class="hero__copy">
        <h1 class="hero__title"><?php echo htmlspecialchars($ayar['hero_baslik']); ?></h1>
        <p class="hero__desc"><?php echo htmlspecialchars($ayar['hero_aciklama']); ?></p>

        <div class="hero__actions">
          <a href="#randevu" class="btn btn--primary"><?php echo htmlspecialchars($ayar['hero_buton1']); ?></a>
          <a href="#hakkimda" class="btn btn--ghost"><span class="play"></span><?php echo htmlspecialchars($ayar['hero_buton2']); ?></a>
        </div>
      </div>

      <div class="hero__person">
        <div class="personCard">
          <!-- BURAYA kendi hero kişi görselini koy -->
          <img src="assets/images/hero-person.jpg" class="personCard__img" alt="Psikolog">
        </div>
      </div>
    </div>
  </section>

  <!-- HAKKIMDA -->
  <section id="hakkimda" class="section section--soft">
    <div class="container about">
      <div class="about__photo">
        <img src="assets/images/about.jpg" alt="Hakkımda">
      </div>

      <div class="about__content">
        <h2 class="section__title"><?php echo htmlspecialchars($ayar['about_baslik']); ?></h2>
        <div class="about__headline">
          <strong><?php echo htmlspecialchars($ayar['about_isim']); ?></strong>, <?php echo htmlspecialchars($ayar['about_unvan']); ?>
        </div>
        <p class="about__text"><?php echo nl2br(htmlspecialchars($ayar['about_metin'])); ?></p>

        <div class="stats">
          <div class="stat"><div class="stat__icon">❤</div><div><div class="stat__num">12+</div><div class="stat__label">Yıl Deneyim</div></div></div>
          <div class="stat"><div class="stat__icon">👥</div><div><div class="stat__num">1000+</div><div class="stat__label">Mutlu Danışan</div></div></div>
          <div class="stat"><div class="stat__icon">🧠</div><div><div class="stat__num">Uzman</div><div class="stat__label">Terapi Yöntemleri</div></div></div>
        </div>

        <a href="#iletisim" class="btn btn--warm btn--pill">Detaylı Bilgi</a>
      </div>
    </div>
  </section>

  <!-- HİZMETLER -->
  <section id="hizmetler" class="section">
    <div class="container">
      <h2 class="section__title center"><?php echo htmlspecialchars($ayar['hizmetler_baslik']); ?></h2>
      <p class="section__subtitle center"><?php echo htmlspecialchars($ayar['hizmetler_alt']); ?></p>

      <div class="cards">
        <article class="card">
          <img src="assets/images/service1.jpg" alt="">
          <div class="card__body">
            <h3>Anksiyete ile Başa Çıkma Yöntemleri</h3>
            <p>Kısa açıklama alanı.</p>
            <div class="card__footer"><a class="link" href="#iletisim">Okumaya Devam</a><span class="chip">Danışanlar</span></div>
          </div>
        </article>

        <article class="card">
          <img src="assets/images/service2.jpg" alt="">
          <div class="card__body">
            <h3>Sağlıklı İlişkiler İçin İpuçları</h3>
            <p>Kısa açıklama alanı.</p>
            <div class="card__footer"><a class="link" href="#iletisim">Okumaya Devam</a><span class="chip">Danışmanlık</span></div>
          </div>
        </article>

        <article class="card">
          <img src="assets/images/service3.jpg" alt="">
          <div class="card__body">
            <h3>Çocuklarda Özgüven Geliştirme</h3>
            <p>Kısa açıklama alanı.</p>
            <div class="card__footer"><a class="link" href="#iletisim">Okumaya Devam</a><span class="chip">Aile</span></div>
          </div>
        </article>
      </div>
    </div>
  </section>

  <!-- BLOG (scroll target) -->
  <section id="blog" class="section section--soft">
    <div class="container">
      <h2 class="section__title center">Blog</h2>
      <p class="section__subtitle center">İstersen burayı sonradan gerçek blog yaparız.</p>
    </div>
  </section>

  <!-- RANDEVU -->
  <section id="randevu" classsection section--appointment">
    <div class="container appointment">
      <div class="appointment__image">
        <img src="assets/images/appointment.jpg" alt="">
      </div>

      <div class="appointment__content">
        <h2 class="section__title"><?php echo htmlspecialchars($ayar['randevu_baslik']); ?></h2>
        <p class="section__subtitle"><?php echo htmlspecialchars($ayar['randevu_alt']); ?></p>

        <?php if($ok): ?>
          <div class="alert success">Randevunuz alındı. En kısa sürede sizinle iletişime geçeceğiz.</div>
        <?php endif; ?>

        <form class="form" method="post" action="randevu_kaydet.php">
          <div class="form__row">
            <input name="adsoyad" placeholder="Adınız" required>
            <input name="email" type="email" placeholder="E posta" required>
          </div>

          <div class="form__row">
            <input name="telefon" placeholder="Telefon" required>
            <input name="telefon2" placeholder="Telefon">
          </div>

          <div class="form__row">
            <select name="hizmet_turu" required>
              <option value="">Hizmet Türü</option>
              <option>Bireysel Terapi</option>
              <option>Çift Terapisi</option>
              <option>Aile Danışmanlığı</option>
              <option>Çocuk / Ergen</option>
            </select>
            <select name="turu">
              <option value="">Türü</option>
              <option>Online</option>
              <option>Yüz yüze</option>
            </select>
            <select name="saat" required>
              <option value="">Saat</option>
              <option>09:00</option><option>10:00</option><option>11:00</option>
              <option>13:00</option><option>14:00</option><option>15:00</option>
              <option>16:00</option><option>17:00</option>
            </select>
          </div>

          <div class="form__row">
            <input type="date" name="tarih" required>
          </div>

          <div class="form__row">
            <input name="notlar" placeholder="Notlarınız">
            <button class="btn btn--primary btn--pill" type="submit">Randevu Al</button>
          </div>
        </form>
      </div>
    </div>
  </section>

  <section id="iletisim" class="section">
    <div class="container">
      <h2 class="section__title center">İletişim</h2>
      <p class="section__subtitle center">Adres / telefon / harita buraya.</p>
    </div>
  </section>
</main>

<footer class="footer">
  <div class="container footer__inner">
    <div class="footer__social">
      <a href="#">f</a><a href="#">◎</a><a href="#">𝕏</a><a href="#">⌁</a>
    </div>
    <div class="footer__copy"><?php echo htmlspecialchars($ayar['footer_yazi']); ?></div>
  </div>
</footer>

<script>
  window.__SLIDES__ = <?php echo json_encode(array_map(fn($s)=>$s['dosya'], $slides), JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE); ?>;
</script>
<script src="assets/js/app.js?v=1"></script>

</body>
</html>
