CREATE TABLE IF NOT EXISTS randevular (
    id                  INT AUTO_INCREMENT PRIMARY KEY,
    adsoyad             VARCHAR(100) NOT NULL,
    email               VARCHAR(100) NOT NULL,
    telefon             VARCHAR(20) NOT NULL,
    hizmet_turu         VARCHAR(100) NOT NULL,
    tarih               DATE NOT NULL,
    saat                VARCHAR(10) NOT NULL,
    notlar              TEXT,
    olusturulma_tarihi  TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS adminler (
    id INT AUTO_INCREMENT PRIMARY KEY,
    kullanici_adi VARCHAR(50) NOT NULL UNIQUE,
    sifre VARCHAR(255) NOT NULL,
    olusturulma_tarihi TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS site_ayarlar (
    id INT PRIMARY KEY,
    hero_baslik VARCHAR(255) NOT NULL,
    hero_aciklama TEXT NOT NULL,
    hero_buton1 VARCHAR(50) NOT NULL,
    hero_buton2 VARCHAR(50) NOT NULL,

    about_baslik VARCHAR(100) NOT NULL,
    about_isim VARCHAR(120) NOT NULL,
    about_unvan VARCHAR(120) NOT NULL,
    about_metin TEXT NOT NULL,

    hizmetler_baslik VARCHAR(80) NOT NULL,
    hizmetler_alt VARCHAR(120) NOT NULL,

    randevu_baslik VARCHAR(120) NOT NULL,
    randevu_alt TEXT NOT NULL,

    footer_yazi VARCHAR(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS slider_resimler (
    id INT AUTO_INCREMENT PRIMARY KEY,
    dosya VARCHAR(255) NOT NULL,
    aktif TINYINT(1) NOT NULL DEFAULT 1,
    sira INT NOT NULL DEFAULT 0,
    olusturulma_tarihi TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO site_ayarlar (
    id, hero_baslik, hero_aciklama, hero_buton1, hero_buton2,
    about_baslik, about_isim, about_unvan, about_metin,
    hizmetler_baslik, hizmetler_alt,
    randevu_baslik, randevu_alt, footer_yazi
) VALUES (
    1,
    'Kendinizi İyi Hissetmeniz İçin Buradayım',
    'Profesyonel psikolojik destek ile hayata yeniden gülümseyin.',
    'Randevu Al',
    'Beni Tanıyın',
    'Hakkımda',
    'Ben [İsim Soyisim]',
    'Uzman Psikolog',
    'Uzman psikolog olarak, danışanlarıma güvenli bir alan sunar; duygusal ve psikolojik süreçlerinde birlikte ilerleriz. Amacım, yaşam kalitenizi artırmak ve size sürdürülebilir çözümler sağlamaktır.',
    'Hizmetlerim',
    'Size Nasıl Yardımcı Olabilirim?',
    'Randevunuzu Oluşturun',
    'Online randevu formu ile kolayca randevunuzu oluşturabilirsiniz.',
    CONCAT('© ', YEAR(CURDATE()), ' Tüm Hakları Saklıdır.')
)
ON DUPLICATE KEY UPDATE
