<?php
require_once __DIR__ . '/db.php';

function clean($s){ return trim((string)$s); }

$adsoyad = clean($_POST['adsoyad'] ?? '');
$email   = clean($_POST['email'] ?? '');
$telefon = clean($_POST['telefon'] ?? '');
$hizmet  = clean($_POST['hizmet_turu'] ?? '');
$tarih   = clean($_POST['tarih'] ?? '');
$saat    = clean($_POST['saat'] ?? '');
$notlar  = clean($_POST['notlar'] ?? '');

if ($adsoyad==='' || $email==='' || $telefon==='' || $hizmet==='' || $tarih==='' || $saat==='') {
  header("Location: index.php#randevu"); exit;
}
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
  header("Location: index.php#randevu"); exit;
}

$telefon = preg_replace('/[^0-9+]/', '', $telefon);

$stmt = $db->prepare("INSERT INTO randevular (adsoyad,email,telefon,hizmet_turu,tarih,saat,notlar) VALUES (?,?,?,?,?,?,?)");
$stmt->execute([$adsoyad,$email,$telefon,$hizmet,$tarih,$saat,$notlar]);

header("Location: index.php?ok=1#randevu");
exit;
