<?php
require "inc/auth.php";
require "inc/db.php";

/* SİL */
if (isset($_GET["sil"])) {
  $id = (int)$_GET["sil"];
  $db->prepare("DELETE FROM hizmetler WHERE id=?")->execute([$id]);
  header("Location: hizmetler.php");
  exit;
}

/* EKLE */
if ($_POST) {
  $baslik = $_POST["baslik"];
  $aciklama = $_POST["aciklama"];
  $resimYol = "";

  if (!empty($_FILES["resim"]["name"])) {
    $dosyaAdi = time() . "_" . $_FILES["resim"]["name"];
    move_uploaded_file(
      $_FILES["resim"]["tmp_name"],
      "uploads/services/" . $dosyaAdi
    );
    $resimYol = "admin/uploads/services/" . $dosyaAdi;
  }

  $stmt = $db->prepare("
    INSERT INTO hizmetler (baslik, aciklama, resim)
    VALUES (?,?,?)
  ");
  $stmt->execute([$baslik, $aciklama, $resimYol]);
}

$hizmetler = $db->query("SELECT * FROM hizmetler ORDER BY id DESC")->fetchAll();
?>

<h1>Hizmetler</h1>

<form method="post" enctype="multipart/form-data" style="margin-bottom:30px">
  <input name="baslik" placeholder="Hizmet Başlığı" required><br><br>
  <textarea name="aciklama" placeholder="Kısa açıklama" required></textarea><br><br>
  <input type="file" name="resim" required><br><br>
  <button>Hizmet Ekle</button>
</form>

<table border="1" cellpadding="10">
<tr>
  <th>Görsel</th>
  <th>Başlık</th>
  <th>Açıklama</th>
  <th>İşlem</th>
</tr>

<?php foreach ($hizmetler as $h): ?>
<tr>
  <td>
    <?php if($h["resim"]): ?>
      <img src="../<?= $h["resim"] ?>" width="80">
    <?php endif; ?>
  </td>
  <td><?= htmlspecialchars($h["baslik"]) ?></td>
  <td><?= htmlspecialchars($h["aciklama"]) ?></td>
  <td>
    <a href="?sil=<?= $h["id"] ?>" onclick="return confirm('Silinsin mi?')">
      ❌ Sil
    </a>
  </td>
</tr>
<?php endforeach; ?>
</table>
