<?php
session_start();
require "inc/db.php";

$error = "";

if ($_POST) {
  $username = $_POST["username"] ?? "";
  $password = $_POST["password"] ?? "";

  $q = $db->prepare("SELECT * FROM admin_users WHERE username = ?");
  $q->execute([$username]);
  $admin = $q->fetch(PDO::FETCH_ASSOC);

  if ($admin && password_verify($password, $admin["password"])) {
    $_SESSION["admin_logged_in"] = true;
    header("Location: randevular.php");
    exit;
  } else {
    $error = "Kullanıcı adı veya şifre hatalı";
  }
}
?>
<!doctype html>
<html lang="tr">
<head>
<meta charset="utf-8">
<title>Admin Giriş</title>

<style>
*{box-sizing:border-box}
body{
  margin:0;
  height:100vh;
  font-family:Arial, Helvetica, sans-serif;
  background:linear-gradient(135deg,#1e3c72,#2a5298);
  display:flex;
  align-items:center;
  justify-content:center;
}

.login-box{
  background:#fff;
  width:360px;
  padding:40px;
  border-radius:16px;
  box-shadow:0 20px 40px rgba(0,0,0,.2);
}

.login-box h2{
  margin:0 0 20px;
  text-align:center;
  color:#1e3c72;
}

.login-box input{
  width:100%;
  padding:14px;
  margin-bottom:14px;
  border:1px solid #ddd;
  border-radius:8px;
  font-size:15px;
}

.login-box button{
  width:100%;
  padding:14px;
  background:#1e3c72;
  color:#fff;
  border:0;
  border-radius:8px;
  font-size:16px;
  cursor:pointer;
}

.login-box button:hover{
  background:#16325c;
}

.error{
  background:#ffe5e5;
  color:#b30000;
  padding:10px;
  border-radius:8px;
  margin-bottom:15px;
  text-align:center;
  font-size:14px;
}

.footer{
  text-align:center;
  margin-top:15px;
  font-size:12px;
  color:#999;
}
</style>

</head>
<body>

<div class="login-box">
  <h2>Admin Panel</h2>

  <?php if($error): ?>
    <div class="error"><?= $error ?></div>
  <?php endif; ?>

  <form method="post">
    <input name="username" placeholder="Benutzername" required>
    <input type="password" name="password" placeholder="Passwort" required>
    <button>Anmelden</button>
  </form>

  <div class="footer">
    © <?= date("Y") ?> Verwaltungspanel
  </div>
</div>

</body>
</html>
