<?php
session_start();
require "inc/db.php";

if (!isset($_SESSION["admin_logged_in"])) {
  header("Location: login.php");
  exit;
}

/* filtre */
$where = "";
$params = [];

if (!empty($_GET["status"]) && $_GET["status"] != "tum") {
  $where = "WHERE status = ?";
  $params[] = $_GET["status"];
}

$q = $db->prepare("
  SELECT * FROM randevular
  $where
  ORDER BY created_at DESC
");
$q->execute($params);
$randevular = $q->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html lang="tr">
<head>
<meta charset="utf-8">
<title>Randevular</title>
<link rel="stylesheet" href="panel.css">
</head>
<body>

<div class="layout">

  <!-- SOL MENÜ -->
  <aside class="sidebar">
    <h2>Yönetici</h2>
    <a class="active">📅 Randevular</a>
    <a href="logout.php">🚪 Çıkış</a>
  </aside>

  <!-- ANA ALAN -->
  <main class="content">
    <h1>Randevular</h1>

    <form method="get" class="filter">
      <select name="status" onchange="this.form.submit()">
        <option value="tum">Tümü</option>
        <option value="bekliyor" <?= (@$_GET["status"]=="bekliyor"?"selected":"") ?>>Bekliyor</option>
        <option value="arandi" <?= (@$_GET["status"]=="arandi"?"selected":"") ?>>Arandı</option>
        <option value="tamamlandi" <?= (@$_GET["status"]=="tamamlandi"?"selected":"") ?>>Tamamlandı</option>
        <option value="iptal" <?= (@$_GET["status"]=="iptal"?"selected":"") ?>>İptal</option>
      </select>
    </form>

    <table>
      <tr>
        <th>Ad Soyad</th>
        <th>Telefon</th>
        <th>Hizmet</th>
        <th>Tarih</th>
        <th>Saat</th>
        <th>Durum</th>
        <th>İşlem</th>
      </tr>

      <?php foreach($randevular as $r): ?>
      <tr>
        <td><?= htmlspecialchars($r["adsoyad"]) ?></td>
        <td><?= htmlspecialchars($r["telefon"]) ?></td>
        <td><?= htmlspecialchars($r["hizmet"]) ?></td>
        <td><?= $r["tarih"] ?></td>
        <td><?= $r["saat"] ?></td>

        <td>
          <span class="badge <?= $r["status"] ?>">
            <?= ucfirst($r["status"]) ?>
          </span>
        </td>

        <td>
          <form method="post" action="status.php">
            <input type="hidden" name="id" value="<?= $r["id"] ?>">
        
            <select name="status" onchange="this.form.submit()" class="status-select">
              <option value="bekliyor" <?= $r["status"]=="bekliyor"?"selected":"" ?>>Bekliyor</option>
              <option value="arandi" <?= $r["status"]=="arandi"?"selected":"" ?>>Arandı</option>
              <option value="tamamlandi" <?= $r["status"]=="tamamlandi"?"selected":"" ?>>Tamamlandı</option>
              <option value="iptal" <?= $r["status"]=="iptal"?"selected":"" ?>>İptal</option>
            </select>
          </form>
        </td>

      </tr>
      <?php endforeach; ?>
    </table>

  </main>
</div>

</body>
</html>
