document.addEventListener("DOMContentLoaded", () => {

  /* ================= HERO SLIDER ================= */
  const heroBg = document.querySelector(".hero-bg");

  const slides = [
    "assets/images/slider/slide1.jpg",
    "assets/images/slider/slide2.jpg"
  ];

  let slideIndex = 0;

  function changeHeroSlide() {
    slideIndex = (slideIndex + 1) % slides.length;
    heroBg.style.opacity = 0;

    setTimeout(() => {
      heroBg.style.backgroundImage = `url('${slides[slideIndex]}')`;
      heroBg.style.opacity = 1;
    }, 400);
  }

  // ���lk y���kleme
  heroBg.style.backgroundImage = `url('${slides[0]}')`;
  heroBg.style.transition = "opacity 0.8s ease";

  setInterval(changeHeroSlide, 10000);



// SERVICES SLIDER
const track = document.getElementById("servicesTrack");
const nextBtn = document.getElementById("serviceNext");
const prevBtn = document.getElementById("servicePrev");

if (track && nextBtn && prevBtn) {

  function getStep() {
    const card = track.querySelector(".service-card");
    const gap = 30;
    return (card.offsetWidth + gap) * 3;
  }

  nextBtn.addEventListener("click", () => {
    track.scrollBy({
      left: getStep(),
      behavior: "smooth"
    });
  });

  prevBtn.addEventListener("click", () => {
    track.scrollBy({
      left: -getStep(),
      behavior: "smooth"
    });
  });

}



  /* ================= MENU SCROLL ================= */
  document.querySelectorAll("a[href^='#']").forEach(link => {
    link.addEventListener("click", e => {
      const targetId = link.getAttribute("href");
      const target = document.querySelector(targetId);

      if (!target) return;

      e.preventDefault();

      const headerOffset = 90;
      const elementPosition = target.getBoundingClientRect().top;
      const offsetPosition = elementPosition + window.pageYOffset - headerOffset;

      window.scrollTo({
        top: offsetPosition,
        behavior: "smooth"
      });
    });
  });

});


