<?php
// slider görselleri (JS kullanacak)
$slides = [
  "assets/images/slider/slide1.jpg",
  "assets/images/slider/slide2.jpg"
];
?>
<!DOCTYPE html>
<html lang="tr">
<head>
  <meta charset="UTF-8">
  <title>Psikolog</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <link rel="stylesheet" href="assets/css/style.css">

  <script>
    window.__SLIDES__ = <?= json_encode($slides) ?>;
  </script>
</head>
<body>

<!-- ================= HEADER ================= -->
<header class="topbar">
  <div class="container nav">
    <div class="logo"><img src="assets/images/Logo.png" class="logo"></div>

    <nav class="menu">
      <a href="#hero">Startseite</a>
      <a href="#about">Über uns</a>
      <a href="#services">Dienstleistungen</a>
      <a href="#appointment">Termin</a>
      <a href="#contact">Kontakt</a>
    </nav>

    <a href="#appointment" class="btn-primary">Termin vereinbaren</a>
  </div>
</header>

<!-- ================= HERO / SLIDER ================= -->
<section id="hero" class="hero">
  <div class="hero-bg" id="heroBg"></div>

  <div class="container hero-content">
    <h1>Ich bin hier, damit Sie sich gut fühlen</h1>
    <p>Lächeln Sie dem Leben mit professioneller psychologischer Unterstützung wieder zu.</p>

    <div class="hero-actions">
      <a href="#appointment" class="btn-primary">Termin vereinbaren</a>
      <a href="#about" class="btn-outline">Lernen Sie mich kennen</a>
    </div>
  </div>
</section>

<!-- ================= ABOUT ================= -->
<section id="about" class="about">
  <!-- ARKA PLAN -->
  <div class="about-bg"></div>

  <div class="container about-layout">
    
    <!-- SOL FOTO KUTUSU -->
    <div class="about-photo">
      <img src="assets/images/slider/about2.jpg" alt="Uzman Psikolog">
    </div>

    <!-- SAĞ İÇERİK KARTI -->
    <div class="about-card">
      <h2>Über uns</h2>

      <p>
        Seelelvra bietet seit 3 Jahren psychologische Beratungsleistungen mit Sitz in Bonn, Deutschland, an. Seit unserer Gründung verfolgen wir das Ziel, 
        das seelische Wohlbefinden von Menschen zu stärken, ihre Lebensqualität zu verbessern und sie dabei zu unterstützen, Herausforderungen auf gesunde Weise zu bewältigen.
        <br/><br/>
        Bei Seelelvra verfolgen wir einen klientenzentrierten, ethisch verantwortungsvollen und wissenschaftlich fundierten Ansatz. Wir sind davon überzeugt, dass die Erfahrungen jedes 
        Menschen einzigartig sind; entsprechend gestalten wir den therapeutischen Prozess individuell, sicher und unter strikter Wahrung der Vertraulichkeit. Unter Berücksichtigung der kulturellen und sozialen Dynamiken von in Deutschland lebenden Menschen bieten wir verständliche und nachhaltige Lösungsansätze an.
      </p>

      <div class="about-stats">

          <div class="stat-box">
            <div class="stat-icon">
              <img src="assets/images/icon1.png" alt="">
            </div>
            <div class="stat-text">
              <strong>12+</strong>
              <span>Jahre Erfahrung</span>
            </div>
          </div>
        
          <div class="stat-box">
            <div class="stat-icon">
              <img src="assets/images/icon2.png" alt="">
            </div>
            <div class="stat-text">
              <strong>1000+</strong>
              <span>Zufriedene Klienten</span>
            </div>
          </div>
        
          <div class="stat-box">
            <div class="stat-icon">
              <img src="assets/images/icon3.png" alt="">
            </div>
            <div class="stat-text">
              <strong>Experte</strong>
              <span>Therapiemethoden</span>
            </div>
          </div>
        
        </div>

      <a href="#" class="btn-secondary">Detaillierte Informationen</a>
    </div>

  </div>
</section>


<!-- ================= SERVICES ================= -->
<section id="services" class="services">
  <div class="container">
    <h2 class="section-title">Meine Dienstleistungen</h2>
    <p class="section-desc">Wie kann ich Ihnen helfen?</p>

    <div class="services-wrapper">
      <button class="nav-arrow left" id="servicePrev">‹</button>

      <div class="services-track" id="servicesTrack">

        <div class="service-card">
          <img src="assets/images/services/bireysel.png" alt="">
          <div class="service-body">
            <h3>Einzeltherapie</h3>
            <p>Individuelle psychologische Unterstützung bei Angst, Stress, Depression und persönlichen Problemen.</p>
            <a href="#appointment" class="service-btn">Detaillierte Informationen</a>
          </div>
        </div>

        <div class="service-card">
          <img src="assets/images/services/cift.png" alt="">
          <div class="service-body">
            <h3>Paartherapie</h3>
            <p>Begleitung bei Beziehungsproblemen, Kommunikationsschwierigkeiten und Eheberatung.</p>
            <a href="#appointment" class="service-btn">Detaillierte Informationen</a>
          </div>
        </div>

        <div class="service-card">
          <img src="assets/images/services/aile.png" alt="">
          <div class="service-body">
            <h3>Familientherapie</h3>
            <p>Arbeit an familiärer Kommunikation, Konflikten sowie Eltern-Kind-Beziehungen und emotionalen Bindungen.</p>
            <a href="#appointment" class="service-btn">Detaillierte Informationen</a>
          </div>
        </div>
        
        <div class="service-card">
          <img src="assets/images/services/cocukveergen.png" alt="">
          <div class="service-body">
            <h3>Kinder- und Jugendtherapie</h3>
            <p>Unterstützung bei Selbstvertrauen, Verhaltensproblemen, schulischer Anpassung und emotionaler Entwicklung.</p>
            <a href="#appointment" class="service-btn">Detaillierte Informationen</a>
          </div>
        </div>
        <div class="service-card">
          <img src="assets/images/services/kaygi.png" alt="">
          <div class="service-body">
            <h3>Angst- und Stressbewältigung</h3>
            <p>Techniken zum Umgang mit Panikattacken, sozialer Angst, Prüfungsangst und anhaltendem Alltagsstress im täglichen Leben.</p>
            <a href="#appointment" class="service-btn">Detaillierte Informationen</a>
          </div>
        </div>
        <div class="service-card">
          <img src="assets/images/services/travma.png" alt="">
          <div class="service-body">
            <h3>Trauma- und Trauerberatung</h3>
            <p>Begleitung nach traumatischen Erlebnissen, Verlust, Trennung/Scheidung und belastenden Lebensereignissen.</p>
            <a href="#appointment" class="service-btn">Detaillierte Informationen</a>
          </div>
        </div>

        <!-- diğer 3 hizmet aynı yapı -->
      </div>

      <button class="nav-arrow right" id="serviceNext">›</button>
    </div>
  </div>
</section>


<!-- ================= APPOINTMENT ================= -->
<!-- ================= APPOINTMENT ================= -->
<!-- ================= APPOINTMENT ================= -->
<!-- ================= APPOINTMENT ================= -->
<section id="appointment" class="appointment-soft">
  <div class="appointment-bg"></div>

  <div class="container appointment-layout">

    <!-- SOL GÖRSEL -->
    <div class="appointment-image">
      <img src="assets/images/appointment.jpg" alt="Danışmanlık">
    </div>

    <!-- SAĞ FORM -->
    <div class="appointment-box">
      <h2>Erstellen Sie Ihren <span>Termin</span></h2>
      <p>Mit dem Online-Terminformular können Sie ganz einfach Ihren Beratungstermin erstellen.</p>

      <form class="appointment-form" method="post" action="randevu_kaydet.php">
        <div class="row two">
          <input type="text" name="adsoyad" placeholder="Ihr Name" required>
          <input type="email" name="email" placeholder="E-Mail" required>
        </div>

        <div class="row two">
          <input type="text" name="telefon" placeholder="Telefon" required>
          <input type="date" name="tarih" required>
        </div>

        <div class="row three">
          <select name="hizmet">
            <option>Art der Dienstleistung</option>
            <option>Einzeltherapie</option>
            <option>Paartherapie</option>
            <option>Familientherapie</option>
          </select>

          <select name="tur">
            <option>Art</option>
            <option>Online</option>
            <option>Persönlich</option>
          </select>

          <select name="saat">
            <option>Uhrzeit</option>
            <option>09:00</option>
            <option>10:00</option>
            <option>11:00</option>
            <option>14:00</option>
          </select>
        </div>

        <div class="row one">
          <input type="text" name="notlar" placeholder="Notlarınız">
          <button type="submit" class="btn-primary">Termin vereinbaren</button>
        </div>
      </form>
    </div>

  </div>
</section>




<!-- ================= CONTACT ================= -->
<!-- ================= FOOTER ================= -->
<footer class="site-footer" id="contact">
  <div class="footer-bg"></div>

  <div class="container footer-content">

    <!-- Logo -->
    <div class="footer-logo">
        <div class="logo"><img src="assets/images/Logo.png" class="logo"></div>
    </div>

    <div class="footer-grid">

      <!-- İletişim -->
      <div class="footer-col">
        <h4>Kontakt</h4>

        <p>📍 Örnek Mahallesi, Beşiktaş<br>İstanbul 34400</p>
        <p>✉️ info@siteadi.com</p>
        <p>📞 +90 555 555 55 55</p>

        <div class="footer-social">
          <a href="#">🌐</a>
          <a href="#">📘</a>
          <a href="#">📸</a>
          <a href="#">💬</a>
        </div>
      </div>

      <!-- Hızlı Menü -->
      <div class="footer-col">
        <h4>Schnellmenü</h4>
        <ul>
          <li><a href="#hero">Startseite</a></li>
          <li><a href="#about">Über uns</a></li>
          <li><a href="#
          ">Dienstleistungen</a></li>
          <li><a href="#appointment">Termin</a></li>
          <li><a href="#contact">Kontakt</a></li>
        </ul>
      </div>

      <!-- Bize Ulaşın -->
      <div class="footer-col">
        <h4>Kontaktieren Sie uns</h4>
        <p>Montag – Freitag<br>09:00 – 18:00</p>

        <form class="footer-form">
          <input type="text" placeholder="Ihre Nachricht">
          <button type="submit">
            Senden →
          </button>
        </form>
      </div>

    </div>

    <div class="footer-bottom">
      info@website.com • © 2024 Alle Rechte vorbehalten
    </div>

  </div>
</footer>


<script src="assets/js/app.js"></script>
</body>
</html>
